/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.arthropod;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.target.DontThreadOnMeTarget;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.util.EntityUtils;

public class EntityTarantula
extends ComplexMob
implements ISpecies,
INewSkins {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(EntityTarantula.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int aggroProgress;
    public int climbProgress;
    public boolean invertClimbing = false;

    public EntityTarantula(EntityType<? extends EntityTarantula> type, Level worldIn) {
        super(type, worldIn);
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 0.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityTarantula.getEcoLevel(input) > EntityTarantula.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntityTarantula.getEcoLevel(input) < EntityTarantula.getEcoLevel((LivingEntity)this)));
        this.f_21346_.m_25352_(3, new DontThreadOnMeTarget<LivingEntity>((Mob)this, LivingEntity.class, true));
    }

    protected PathNavigation m_6037_(Level p_33802_) {
        return new WallClimberNavigation((Mob)this, p_33802_);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.breed();
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
            this.setAngry(this.m_5448_() != null);
            this.setClimbing(this.f_19862_ && EntityTarantula.nextToClimbableBlock(this));
            if (!this.m_20096_() && !this.isClimbing() && this.m_20184_().m_7098_() < 0.0 && EntityTarantula.nextToClimbableBlock(this)) {
                this.m_20256_(this.m_20184_().m_82542_(0.0, 0.5, 0.0));
                this.setClimbing(true);
            }
        }
        if (this.f_19853_.m_5776_()) {
            if (this.isAngry() && this.aggroProgress < 40) {
                ++this.aggroProgress;
            } else if (!this.isAngry() && this.aggroProgress > 0) {
                --this.aggroProgress;
            }
            if (this.isClimbing() && this.climbProgress < 20) {
                ++this.climbProgress;
            } else if (!this.isClimbing() && this.climbProgress > 0) {
                --this.climbProgress;
            }
            if (this.climbProgress % 20 != 0 && this.invertClimbing != this.m_20184_().m_7098_() < 0.0) {
                this.invertClimbing = !this.m_20096_() && this.m_20184_().m_7098_() < 0.0;
            }
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityTarantula.class, this.m_142469_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.m_146764_());
                ((EntityTarantula)list.get(0)).m_146762_(this.m_146764_());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_tarantula", this.getOffspring());
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41720_() == Items.f_42590_ && this.m_6084_()) {
            EntityUtils.turnEntityIntoItem((LivingEntity)this, "bottle_tarantula");
            itemstack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_142535_(float p_148859_, float p_148860_, DamageSource p_148861_) {
        return false;
    }

    public boolean m_7327_(Entity entityIn) {
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f);
        if (flag) {
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 80, 0));
            }
            return true;
        }
        return false;
    }

    public boolean m_7301_(MobEffectInstance potionEffectIn) {
        return potionEffectIn.m_19544_() != MobEffects.f_19614_ && super.m_7301_(potionEffectIn);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean isClimbing() {
        return (Boolean)this.f_19804_.m_135370_(CLIMBING) != false && EntityTarantula.nextToClimbableBlock(this);
    }

    public static boolean nextToClimbableBlock(EntityTarantula entityIn) {
        Level world = entityIn.m_183503_();
        BlockPos pos_1 = entityIn.m_142538_().m_142022_(Math.cos(Math.toRadians(entityIn.m_146908_() + 90.0f)) * 1.2, 0.0, Math.sin(Math.toRadians(entityIn.m_146908_() + 90.0f)) * 1.2);
        BlockPos pos_2 = entityIn.m_142538_().m_142022_(Math.cos(Math.toRadians(entityIn.m_146908_() + 90.0f)) * -1.2, 0.0, Math.sin(Math.toRadians(entityIn.m_146908_() + 90.0f)) * -1.2);
        BlockState block_1 = world.m_8055_(pos_1);
        BlockState block_2 = world.m_8055_(pos_2);
        return block_1.m_60838_((BlockGetter)world, pos_1) || block_2.m_60838_((BlockGetter)world, pos_2);
    }

    public void setClimbing(boolean p_33820_) {
        this.f_19804_.m_135381_(CLIMBING, (Object)p_33820_);
    }
}

